﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting;
using Microsoft.Reporting.WebForms;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Custom.BCR
{
    public partial class RunReport : BasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);

                if (UserSession == null)
                {
                    Response.Redirect("~/Default.aspx", false);
                }
                else if (string.IsNullOrEmpty(UserSession.CurrentReportPath))
                {
                    Response.Redirect("~/Custom/BCR/Default.aspx", false);
                }
                else
                {
                    if (!Page.IsPostBack)
                        LoadReport();

                    SetMenu();
                }

                ScriptManager.RegisterStartupScript(this, this.GetType(), "moveReportViewerButton", "moveReportViewerButton('reportViewer');", true);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void LoadReport()
        {
            reportViewer.Reset();
            reportViewer.ProcessingMode = ProcessingMode.Remote;
            reportViewer.ServerReport.Timeout = (Timeout * 1000); //this timeout is in milliseconds
            reportViewer.ServerReport.ReportServerUrl = new Uri(ReportServerUrl);
            reportViewer.ServerReport.ReportPath = UserSession.CurrentReportPath;

            ReportParameterInfoCollection parameters = reportViewer.ServerReport.GetParameters();
            if (parameters != null)
            {
                ReportParameterInfo userParameter = parameters.FirstOrDefault(param => param.Name == "CurrentUser");
                if (userParameter != null)
                {
                    reportViewer.ServerReport.SetParameters(new ReportParameter("CurrentUser", HttpContext.Current.User.Identity.Name));
                }

                if (UserSession.CurrentReportPath == "/Reports/BCR/Utility Patient Search")
                {
                    string strPatientSearch = UserSession.PatientSearch;
                    ReportParameterInfo searchParameter = parameters.FirstOrDefault(param => param.Name == "PatientSearch");
                    if (searchParameter != null)
                    {
                        reportViewer.ServerReport.SetParameters(new ReportParameter("PatientSearch", strPatientSearch));
                    }
                    UserSession.PatientSearch = string.Empty;
                }
            }

            reportViewer.ServerReport.Refresh();
        }

        private void SetMenu()
        {
            Menu topMenu = this.Master.FindControl("mnuTopMenu") as Menu;
            if (topMenu != null)
            {
                if (topMenu.Items != null && topMenu.Items.Count > 0)
                {
                    foreach (MenuItem mi in topMenu.Items)
                    {
                        if (mi.Text == "Help")
                        {
                            string helpString = GetReportHelpString();
                            mi.NavigateUrl = helpString;

                            if (Page.IsPostBack)
                            {
                                helpString = helpString.Replace("~/Custom/BCR/", "");
                                ScriptManager.RegisterStartupScript(this, this.GetType(), "updateHelpLink", "updateHelpLink('" + helpString + "');", true);
                            }
                        }
                    }
                }
            }
        }

        private string GetReportHelpString()
        {
            string reportHelp = "~/Help/Default.aspx";

            if (reportViewer != null && reportViewer.ServerReport != null && !string.IsNullOrEmpty(reportViewer.ServerReport.ReportPath))
            {
                switch (reportViewer.ServerReport.ReportPath)
                {
                    case "/Reports/BCR/Ad hoc Reporting Dashboard":
                        reportHelp = "~/Custom/BCR/Help/reports_adhocreportingdashboard.html";
                        break;
                    case "/Reports/BCR/Aggregate Report All Mammograms with BI-RADS Distribution":
                        reportHelp = "~/Custom/BCR/Help/reports_mammobiraddistribution_agg_rpt.html";
                        break;

                    case "/Reports/BCR/Aggregate Report Breast Cancer":
                        reportHelp = "~/Custom/BCR/Help/reports_breastcancer_agg_rpt.html";
                        break;
                    case "/Reports/BCR/Sub/Aggregate Report Breast Cancer By Age":
                        reportHelp = "~/Custom/BCR/Help/reports_breastcancer_agg_rpt.html";
                        break;
                    case "/Reports/BCR/Sub/Aggregate Report Breast Cancer By Facility":
                        reportHelp = "~/Custom/BCR/Help/reports_breastcancer_agg_rpt.html";
                        break;
                    case "/Reports/BCR/Sub/Aggregate Report Breast Cancer By Race":
                        reportHelp = "~/Custom/BCR/Help/reports_breastcancer_agg_rpt.html";
                        break;

                    case "/Reports/BCR/Aggregate Report Mammogram Compliance":
                        reportHelp = "~/Custom/BCR/Help/reports_mammogramcompliance_agg_rpt.html";
                        break;
                    case "/Reports/BCR/Sub/Aggregate Report Mammogram Compliance By Age":
                        reportHelp = "~/Custom/BCR/Help/reports_mammogramcompliance_agg_rpt.html";
                        break;
                    case "/Reports/BCR/Sub/Aggregate Report Mammogram Compliance By Facility":
                        reportHelp = "~/Custom/BCR/Help/reports_mammogramcompliance_agg_rpt.html";
                        break;
                    case "/Reports/BCR/Sub/Aggregate Report Mammogram Compliance By Race":
                        reportHelp = "~/Custom/BCR/Help/reports_mammogramcompliance_agg_rpt.html";
                        break;

                    case "/Reports/BCR/Sub/Aggregate Report Mammograms Follow-Up Compliance":
                        reportHelp = "~/Custom/BCR/Help/reports_mammogramfollowupcompliance_agg_rpt.html";
                        break;
                    case "/Reports/BCR/Sub/Aggregate Report Mammograms Follow-Up Compliance By Facility":
                        reportHelp = "~/Custom/BCR/Help/reports_mammogramfollowupcompliance_agg_rpt.html";
                        break;

                    case "/Reports/BCR/Standard Report All Mammograms Abnormal":
                        reportHelp = "~/Custom/BCR/Help/reports_allmammogram_abnormal_rpt.html";
                        break;
                    case "/Reports/BCR/Standard Report Breast Biopsies Surgeries":
                        reportHelp = "~/Custom/BCR/Help/reports_breastbiospies_surgeries_rpt.html";
                        break;
                    case "/Reports/BCR/Standard Report Breast Cancer":
                        reportHelp = "~/Custom/BCR/Help/reports_breastcancer_rpt.html";
                        break;
                    case "/Reports/BCR/Standard Report Mammograms Due":
                        reportHelp = "~/Custom/BCR/Help/reports_mammosdue_std_rpt.html";
                        break;
                    case "/Reports/BCR/Standard Report Ordered Pending":
                        reportHelp = "~/Custom/BCR/Help/reports_orderedpending_std_rpt.html";
                        break;
                    case "/Reports/BCR/Patient_Details":
                        reportHelp = "~/Custom/BCR/Help/reports_patientdetails.html";
                        break;
                    case "/Reports/BCR/Utility Patient Search":
                        reportHelp = "~/Custom/BCR/Help/reports_patientsearchresults.html";
                        break;
                    case "/Reports/BCR/Utility VISN Facility Search":
                        reportHelp = "~/Custom/BCR/Help/reports_visnfacilitysearch.html";
                        break;
                    default:
                        reportHelp = "~/Help/Default.aspx";
                        break;
                }
            }

            return reportHelp;
        }
    }
}